//
// Fragment shader for Vignette effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform float innerRadius;
uniform float outerRadius;
uniform float centerX;
uniform float centerY;

uniform vec2 drawingOffset;
uniform vec2 drawingScale;
uniform vec4 drawingBoundsRect;
uniform vec4 textureRect;
varying vec2 gUV;

void main(void)
{
     if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        vec4 outColor = texture2DRect(texUnit, gUV);
        // This pixel location
        vec3 pCoord = gl_FragCoord.xyz;
        // Transform back to render traget coord space
        pCoord /= vec3(drawingScale, 1);
        pCoord += vec3(drawingOffset, 0);
        // Calculate the distance from this pixel to the center
        float distance =sqrt(pow(pCoord.x-centerX, 2.0) +pow(pCoord.y-centerY,2.0));
        
        float v =(outerRadius-distance)/(outerRadius-innerRadius);
        v = clamp(v, 0.0, 1.0);
        gl_FragColor =  v*modulateColor * outColor;
        gl_FragColor.a =  outColor.a;
      /*
        if ( distance < 2.0)
                gl_FragColor = vec4(1,0,0,0);
        else if ( distance <outerRadius)
            gl_FragColor = vec4(1,0,1,0);
        else if (distance > outerRadius)
            // gl_FragColor = 0.0*outColor;
            gl_FragColor = vec4(0,0,0,0);
        else
            gl_FragColor = vec4(0,1,0,0);
       */
        
    }
}

